/**
 * 
 */
package gov.va.med.mhv.usermgmt.jms;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator;

/**
 * @author vhaislegberb
 *
 */
@Component
public class JmsMviTreatmentFacilityUpdator implements MviTreatmentFacilityUpdator {
	
	private static Logger LOGGER = LogManager.getLogger(JmsMviTreatmentFacilityUpdator.class);
	
	@Autowired
	private PatientConverter patientConverter;
	
	@Autowired
	private MviIntegrationService mviIntegrationService;

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviTreatmentFacilityUpdator#updateTreatmentFacilitiesForExistingPatients(gov.va.med.mhv.common.data.model.Patient)
	 */
	@Override
	@JmsListener(destination = "jms/usermgmt/UPDATE_FACILITIES_Q", containerFactory = "jmsListenerContainerFactory")
	public void updateTreatmentFacilitiesForExistingPatients(PatientDTO patientDTO) throws MHVException {
		try {
			ResponseUtil<Patient> response = new ResponseUtil<Patient>();
			this.mviIntegrationService.updateTreatmentFacilitiesForExistingPatients(patientConverter.convertDTOProfile(patientDTO), response);
			
			if(response.isFailure()) {
				throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
			}
		} catch(MHVException ex) {
			String msg = String.format("An error occurred while performing treatment facility update for user: %s", getNullSafeUsername(patientDTO));
			LOGGER.error(msg, ex);
			throw ex;
		} catch(Exception ex) {
			String msg = String.format("An error occurred while performing treatment facility update for user: %s", getNullSafeUsername(patientDTO));
			LOGGER.error(msg, ex);
			throw new MHVException(msg, ex);
		}

	}
	
	private String getNullSafeUsername(PatientDTO p) {
		if(p != null && p.getUserProfile() != null) {
			return p.getUserProfile().getUserName();
		}
		
		return "nullPatientOrUser";
	}

}
